////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN
@class OrchestrationUser;

NS_REFINED_FOR_SWIFT
@interface CDDCMessageParams : NSObject

/**
 * The unique identifier of the user
 */
@property (nonatomic, strong) OrchestrationUser *orchestrationUser;

/**
 * The event name related to the collected data
 */
@property (nonatomic, copy) NSString *eventName;

@property (nonatomic, copy) NSString *applicationData;

/**
 * True if the CDDC data must be encrypted
 */
@property (nonatomic) BOOL encrypted;

- (instancetype)initWithOrchestrationUser:(OrchestrationUser *)orchestrationUser
                                eventName:(NSString *)eventName
                          applicationData:(NSString *)applicationData
                                encrypted:(BOOL)encrypted;
@end

NS_ASSUME_NONNULL_END
